OPTIONS NOLABEL;

LIBNAME alldat '~/jim/data';

DATA poverty;
  SET alldat.cons_final60_11(KEEP=qyear cons1-cons9 ref_year newid wgt20 educ_ref ftype ref_race region 
		     bls_urbn incweek1 incweek2 earn_comp hispanic age_ref ed_type sex_ref scale
		     fdhomepq2 fdhomecq2 rendwepq rendwecq utilpq utilcq hflow tflow2 tflow
		     ckbkactx_ ckbkactx secestx_ secestx usbndx_ usbndx savacctx_ savacctx assets72 
				 tot_debt2 rt1 srv_year respstat cutenure);
RUN;

PROC SORT DATA=alldat.mortgage8811;
   BY newid;
RUN;
PROC SORT DATA=alldat.home_eq9111;
   BY newid;
RUN;
PROC SORT DATA=alldat.heloc9111;
   BY newid;
RUN;
PROC SORT DATA=alldat.home_val8411;
   BY newid;
RUN;
PROC SORT DATA=poverty;
   BY newid;
RUN;


DATA alldat.inequaltiy00_11;
   MERGE poverty(IN=in1)                     
   			 alldat.mortgage8811(KEEP=newid principal)
   			 alldat.home_eq9111(KEEP=newid prin_hel)
   			 alldat.heloc9111(KEEP=newid prin_loc)
   			 alldat.home_val8411(KEEP=newid n_hous totpval);
   BY newid;
   IF in1;
   
IF (801 LE qyear LE 813) OR (qyear GE 994);
RUN;

***********************************************************************
PROGRAM TO GENERATE FINAL RESULTS
***********************************************************************;

FILENAME outfile1 '~/jim/inequality/output/replicate_cons1.dat';
FILENAME outfile6 '~/jim/inequality/output/replicate_cons2.dat';

DATA poverty;
   SET alldat.inequaltiy00_11; 

   ARRAY recode principal prin_hel prin_loc totpval houseval houseval2 n_hous;
   DO OVER recode;
      IF recode=. THEN recode=0;
   END;   
 
      * NOTE FOR 60-81 THIS IS JUST THE VALUE OF THE SAMPLE UNIT, NOT ADDITIONAL HOMES;
   IF 60 LE srv_year LE 62 THEN all_prop_val=houseval2;
      ELSE IF 70 LE srv_year LE 74 THEN all_prop_val=houseval;
      ELSE IF srv_year GE 80 THEN all_prop_val=totpval;
 

* DELETE OBSERVATIONS IN YEARS NOT REPORTED THUS FAR;
IF ref_year NE 1979;
IF ref_year NE 2012;

IF ref_year=1980 THEN cpi_u_rs_adj_11=2.041;
ELSE IF ref_year=1981 THEN cpi_u_rs_adj_11=1.878;
ELSE IF ref_year=1982 THEN cpi_u_rs_adj_11=1.784;
ELSE IF ref_year=1983 THEN cpi_u_rs_adj_11=1.724;
ELSE IF ref_year=1984 THEN cpi_u_rs_adj_11=1.669;
ELSE IF ref_year=1985 THEN cpi_u_rs_adj_11=1.627;
ELSE IF ref_year=1986 THEN cpi_u_rs_adj_11=1.61;
ELSE IF ref_year=1987 THEN cpi_u_rs_adj_11=1.57;
ELSE IF ref_year=1988 THEN cpi_u_rs_adj_11=1.526;
ELSE IF ref_year=1989 THEN cpi_u_rs_adj_11=1.474;
ELSE IF ref_year=1990 THEN cpi_u_rs_adj_11=1.415;
ELSE IF ref_year=1991 THEN cpi_u_rs_adj_11=1.377;
ELSE IF ref_year=1992 THEN cpi_u_rs_adj_11=1.353;
ELSE IF ref_year=1993 THEN cpi_u_rs_adj_11=1.331;
ELSE IF ref_year=1994 THEN cpi_u_rs_adj_11=1.313;
ELSE IF ref_year=1995 THEN cpi_u_rs_adj_11=1.293;
ELSE IF ref_year=1996 THEN cpi_u_rs_adj_11=1.269;
ELSE IF ref_year=1997 THEN cpi_u_rs_adj_11=1.252;
ELSE IF ref_year=1998 THEN cpi_u_rs_adj_11=1.245;
ELSE IF ref_year=1999 THEN cpi_u_rs_adj_11=1.229;
ELSE IF ref_year=2000 THEN cpi_u_rs_adj_11=1.198;
ELSE IF ref_year=2001 THEN cpi_u_rs_adj_11=1.175;
ELSE IF ref_year=2002 THEN cpi_u_rs_adj_11=1.165;
ELSE IF ref_year=2003 THEN cpi_u_rs_adj_11=1.149;
ELSE IF ref_year=2004 THEN cpi_u_rs_adj_11=1.127;
ELSE IF ref_year=2005 THEN cpi_u_rs_adj_11=1.099;
ELSE IF ref_year=2006 THEN cpi_u_rs_adj_11=1.073;
ELSE IF ref_year=2007 THEN cpi_u_rs_adj_11=1.051;
ELSE IF ref_year=2008 THEN cpi_u_rs_adj_11=1.02;
ELSE IF ref_year=2009 THEN cpi_u_rs_adj_11=1.032;
ELSE IF ref_year=2010 THEN cpi_u_rs_adj_11=1.024;
ELSE IF ref_year=2011 THEN cpi_u_rs_adj_11=1;




   ARRAY contemp(1:9) cons1-cons9;
   ARRAY r_cons(1:9) ;

   DO t=1 TO 9; 
    r_cons(t)=contemp(t)*cpi_u_rs_adj_11;
   END;

r_cons5_2=r_cons5*r_cons5;
r_cons5_3=r_cons5*r_cons5*r_cons5;


*****************************************************************************
DEMOGRAPHICS 
*****************************************************************************;

male=2-sex_ref;

ARRAY fam(1:5); 
ARRAY fam_male(1:5); 
     
   DO t=1 TO 5; 
     IF ftype=t THEN fam(t)=1; 
       ELSE fam(t)=0; 
     fam_male(t)=fam(t)*male;
   END; 
     
ARRAY reg(1:4);
   DO t=1 to 4;
        IF region=t THEN reg(t)=1;
        ELSE reg(t)=0;
* REGION IS MISSING FOR RURALS 1980-1995, SO DEFINE REGION ONLY FOR URBANS;
        IF bls_urbn=2 THEN reg(t)=0;
end;

urban=2-bls_urbn;
      
IF ref_year GE 1979 THEN DO;
   IF ref_race=1 AND hispanic=0 THEN race1=1;
     ELSE race1=0;
   IF ref_race=2 AND hispanic=0 THEN race2=1;
     ELSE race2=0; 
   race3=1-race1-race2;
END; 
IF 1959 LE ref_year LE 1973 THEN DO;
   IF ref_race=1 THEN race1=1;
     ELSE race1=0;
   IF ref_race=2 THEN race2=1;
     ELSE race2=0;   
   race3=1-race1-race2;
END;
      
IF ref_year GE 1972 THEN DO;
  IF incweek1 GT 0 THEN emp=1; 
   ELSE IF incweek1 NE . THEN emp=0; 
END; 
IF 1959 LE ref_year LE 1961 THEN DO; 
  IF 0 LE earn_comp LE 5 THEN emp=1; 
   ELSE emp=0;
  IF earn_comp IN(2,5,7,9) THEN emp2=1;
   ELSE emp2=0; 
END; 
 
IF 1972 LE ref_year LE 1973 THEN DO;
  IF incweek2 GT 0 THEN emp2=1;
    ELSE IF incweek2 NE . THEN emp2=0;  
END; 
IF ref_year GE 1979 THEN DO; 
  IF incweek2 GT 0 THEN emp2=1; 
    ELSE emp2=0;
END; 
   
IF emp=1 AND emp2=1 THEN emp_type=1;   
   ELSE IF emp=1 AND emp2=0 THEN emp_type=2;
   ELSE IF emp=0 AND emp2=1 THEN emp_type=3;
   ELSE IF emp=0 AND emp2=0 THEN emp_type=4;
   ELSE emp_type=0;
   
IF race1=1 THEN race_type=1; 
   ELSE IF race2=1 THEN race_type=2;
   ELSE IF race3=1 THEN race_type=3; 
     
*ed_type already defined for 6061;
IF 1972 LE ref_year LE 1973 THEN DO;
        IF educ_ref IN(1,2,6) THEN ed_type=1;
           ELSE IF educ_ref=3 THEN ed_type=2;
           ELSE IF educ_ref=4 THEN ed_type=3;  
           ELSE IF educ_ref=5 THEN ed_type=4;
END; 
IF 801 LE qyear LE 955 THEN DO;
        IF educ_ref=1 or educ_ref=2 or educ_ref=7 then ed_type=1;
           ELSE IF educ_ref=3 then ed_type=2;
           ELSE IF educ_ref=4 then ed_type=3;
           ELSE IF educ_ref=5 or educ_ref=6 then ed_type=4;
END; 
IF qyear GT 955 THEN DO; 
        IF educ_ref=0 or educ_ref=10 or educ_ref=11 then ed_type=1;
           ELSE IF educ_ref=12 then ed_type=2;
           ELSE IF 13 LE educ_ref LE 14 then ed_type=3;
           ELSE IF 15 LE educ_ref LE 17 THEN ed_type=4;
END; 
         
ARRAY ed(1:4); 
  DO t=1 TO 4; 
     IF ed_type=t THEN ed(t)=1; 
       ELSE ed(t)=0;
END; 
         

IF 0 LE age_ref LE 34 THEN age_grp=1;
   ELSE IF 35 LE age_ref LE 49 THEN age_grp=2;
   ELSE IF 50 LE age_ref LE 64 THEN age_grp=3;
   ELSE IF age_ref GE 65 THEN age_grp=4;

IF 1959 LE ref_year LE 1961 THEN DO;    
  IF cutenure=1 THEN ownhome=1;
    ELSE IF cutenure=2 THEN ownhome=0;
END;

IF ref_year GE 1971 THEN DO;    
  IF cutenure IN(1,2,3) THEN ownhome=1;
    ELSE IF cutenure IN(4,5,6) THEN ownhome=0;
END;

            
* REGION IS MISSING FOR RURALS 1980-1995, SO CREATE REGION CODE;
            
IF bls_urbn=2 THEN region_code=5;
   ELSE IF bls_urbn=1 THEN region_code=region;
    
age_ref_2=age_ref*age_ref;
age_ref_3=age_ref*age_ref*age_ref;


***************************************************************************
ASSETS AND DEBTS
***************************************************************************;

IF ckbkactx_="A" THEN ckbkactx=0;
IF secestx_="A" THEN secestx=0;
IF usbndx_="A" THEN usbndx=0;
IF savacctx_="A" THEN savacctx=0;


ARRAY ass_array ckbkactx secestx usbndx savacctx;
DO OVER ass_array;
   IF rt1 NE 5 THEN ass_array=.;
END;
 
 
tot_assets=ckbkactx+ secestx+ usbndx+ savacctx;

IF 1972 LE ref_year LE 1973 THEN tot_assets=assets72;
* DON'T HAVE LEVELS IN 1960-61, ONLY CHANGES, ALSO NEED TO PUT IN 1961 $s BEFORE CONVERTING
  TO 2005 $s SINCE REF_YEAR=1961 FOR ALL IN 60s;


r_tot_assets=tot_assets*cpi_u_rs_adj_11;
r_tot_debt=tot_debt2*cpi_u_rs_adj_11;   

r_house_val=all_prop_val*cpi_u_rs_adj_11; 
r_house_eq=(all_prop_val-principal-prin_hel-prin_loc)*cpi_u_rs_adj_11; 
r_house_debt=(principal+prin_hel+prin_loc)*cpi_u_rs_adj_11; 
r_tot_ass_incl_heq=r_tot_assets+r_house_eq;
r_tot_ass_incl_hval=r_tot_assets+r_house_val;
r_net_worth=r_tot_assets+r_house_eq-r_tot_debt;


* GEN PERIOD VAR FOR CONSUMPTION GROWTH BY ASSET QUINTILE RESULTS;
IF ref_year=2000 THEN period_grp=1;
   ELSE IF ref_year=2006 THEN period_grp=2;
   ELSE IF ref_year=2011 THEN period_grp=3;


RUN;

PROC MEANS;
RUN;

PROC SORT DATA=poverty;
  BY period_grp;
RUN;

***************************************************************************
CREATE QUINTILE INDICATORS, NOTE PROC RANK CANT USE WEIGHT STATEMENT
***************************************************************************;
PROC RANK DATA=poverty GROUPS=5 OUT=quint(KEEP=newid tass_quint fass_quint hass_quint);
   BY period_grp;
   VAR r_tot_ass_incl_heq r_tot_assets r_house_eq;
	 RANKS tass_quint fass_quint hass_quint;
RUN;
PROC SORT DATA=poverty;
  BY newid;
RUN;
PROC SORT DATA=quint;
  BY newid;
RUN;

DATA poverty;
   MERGE poverty quint;
   BY newid;
RUN;



****************************************************
REGRESSIONS FOR PREDICTING CONSUMPTION FROM CORE
****************************************************;
PROC REG DATA=poverty OUTEST=est_2;
  WHERE 801 LE qyear LE 813;
  MODEL r_cons6 = r_cons5 r_cons5_2 r_cons5_3 age_ref age_ref_2 age_ref_3 ed2-ed4 fam2-fam5 race2 race3;
RUN;
PROC SCORE DATA=poverty SCORE=est_2 OUT=pred_2 TYPE=PARMS;
  ID newid;
  VAR r_cons5 r_cons5_2 r_cons5_3 age_ref age_ref_2 age_ref_3 ed2-ed4 fam2-fam5 race2 race3;
RUN;    


PROC SORT DATA=poverty;
   BY newid;
RUN;
PROC SORT DATA=pred_2;
   BY newid;
RUN;

DATA poverty; 
  MERGE poverty(IN=IN1)
        pred_2(KEEP=newid model1 RENAME=(model1=pred_cons6)) ; 
  BY newid;
  IF in1;

RUN;

PROC SORT DATA=poverty;
  BY ref_year;
RUN;

proc univariate data=poverty;
   var cons1-cons7 pred_cons6 ;
   BY ref_year;
   weight wgt20;
   output out=out_dat1 PCTLPTS=5 10 20 25 40 50 60 75 80 90 95
		     pctlpre=cons1_ cons2_ cons3_ cons4_ cons5_ cons6_ cons7_ cons8_ 
		     pctlname=p5 p10 p20 p25 p40 p50 p60 p75 p80 p90 p95;
RUN;


******************************************************
* GEN CONSUMPTION GROWTH BY ASSET QUINTILE, AGE GROUP, ETC. RESULTS
******************************************************;
PROC SORT DATA=poverty;
  BY period_grp tass_quint;
RUN;
PROC MEANS DATA=poverty;
  WHERE period_grp IN(1,2,3);
  BY period_grp tass_quint;
  VAR pred_cons6 r_cons9;
  OUTPUT OUT=cons_by_tassq MEAN=;
RUN;
PROC MEANS DATA=poverty;
  WHERE period_grp IN(1,2,3) AND respstat=1;
  BY period_grp tass_quint;
  VAR pred_cons6 r_cons9;
  OUTPUT OUT=cons_by_tassq2 MEAN=;
RUN;
PROC MEANS DATA=poverty;
  WHERE period_grp IN(1,2,3) AND respstat=1 AND age_ref LT 65;
  BY period_grp tass_quint;
  VAR pred_cons6 r_cons9;
  OUTPUT OUT=cons_by_tassq3 MEAN=;
RUN;
PROC MEANS DATA=poverty;
  WHERE period_grp IN(1,2,3) AND respstat=1 AND age_ref GE 65;
  BY period_grp tass_quint;
  VAR pred_cons6 r_cons9;
  OUTPUT OUT=cons_by_tassq4 MEAN=;
RUN;

PROC SORT DATA=poverty;
  BY period_grp fass_quint;
RUN;
PROC MEANS DATA=poverty;
  WHERE period_grp IN(1,2,3);
  BY period_grp fass_quint;
  VAR pred_cons6 r_cons9;
  OUTPUT OUT=cons_by_fassq MEAN=;
RUN;
PROC MEANS DATA=poverty;
  WHERE period_grp IN(1,2,3) AND respstat=1;
  BY period_grp fass_quint;
  VAR pred_cons6 r_cons9;
  OUTPUT OUT=cons_by_fassq2 MEAN=;
RUN;
PROC MEANS DATA=poverty;
  WHERE period_grp IN(1,2,3) AND respstat=1 AND age_ref LT 65;
  BY period_grp fass_quint;
  VAR pred_cons6 r_cons9;
  OUTPUT OUT=cons_by_fassq3 MEAN=;
RUN;
PROC MEANS DATA=poverty;
  WHERE period_grp IN(1,2,3) AND respstat=1 AND age_ref GE 65;
  BY period_grp fass_quint;
  VAR pred_cons6 r_cons9;
  OUTPUT OUT=cons_by_fassq4 MEAN=;
RUN;

PROC SORT DATA=poverty;
  BY period_grp hass_quint;
RUN;
PROC MEANS DATA=poverty;
  WHERE period_grp IN(1,2,3);
  BY period_grp hass_quint;
  VAR pred_cons6 r_cons9;
  OUTPUT OUT=cons_by_hassq MEAN=;
RUN;
PROC MEANS DATA=poverty;
  WHERE period_grp IN(1,2,3) AND respstat=1;
  BY period_grp hass_quint;
  VAR pred_cons6 r_cons9;
  OUTPUT OUT=cons_by_hassq2 MEAN=;
RUN;
PROC MEANS DATA=poverty;
  WHERE period_grp IN(1,2,3) AND respstat=1 AND age_ref LT 65;
  BY period_grp hass_quint;
  VAR pred_cons6 r_cons9;
  OUTPUT OUT=cons_by_hassq3 MEAN=;
RUN;
PROC MEANS DATA=poverty;
  WHERE period_grp IN(1,2,3) AND respstat=1 AND age_ref GE 65;
  BY period_grp hass_quint;
  VAR pred_cons6 r_cons9;
  OUTPUT OUT=cons_by_hassq4 MEAN=;
RUN;

* BY AGE GROUP;
PROC SORT DATA=poverty;
  BY period_grp age_grp;
RUN;
PROC MEANS DATA=poverty;
  WHERE period_grp IN(1,2,3) AND respstat=1;
  BY period_grp age_grp;
  VAR pred_cons6 r_cons9;
  OUTPUT OUT=cons_by_age_grp MEAN=;
RUN;

* BY ED GROUP;
PROC SORT DATA=poverty;
  BY period_grp ed_type;
RUN;
PROC MEANS DATA=poverty;
  WHERE period_grp IN(1,2,3) AND respstat=1;
  BY period_grp ed_type;
  VAR pred_cons6 r_cons9;
  OUTPUT OUT=cons_by_ed_grp MEAN=;
RUN;

* BY HOMEOWN GROUP;
PROC SORT DATA=poverty;
  BY period_grp ownhome;
RUN;
PROC MEANS DATA=poverty;
  WHERE period_grp IN(1,2,3) AND respstat=1;
  BY period_grp ownhome;
  VAR pred_cons6 r_cons9;
  OUTPUT OUT=cons_by_home_own MEAN=;
RUN;

*************************************************************************************************************
  GENERATE OUTPUT FILES
*************************************************************************************************************;
DATA _null_; 
   SET out_dat1;
   FILE outfile1 lrecl=2500; 
   PUT ref_year 
       cons1_p5 cons1_p10 cons1_p20 cons1_p25 cons1_p40 cons1_p50 cons1_p60 cons1_p75 cons1_p80 cons1_p90 cons1_p95
       cons2_p5 cons2_p10 cons2_p20 cons2_p25 cons2_p40 cons2_p50 cons2_p60 cons2_p75 cons2_p80 cons2_p90 cons2_p95
       cons3_p5 cons3_p10 cons3_p20 cons3_p25 cons3_p40 cons3_p50 cons3_p60 cons3_p75 cons3_p80 cons3_p90 cons3_p95
       cons4_p5 cons4_p10 cons4_p20 cons4_p25 cons4_p40 cons4_p50 cons4_p60 cons4_p75 cons4_p80 cons4_p90 cons4_p95
       cons5_p5 cons5_p10 cons5_p20 cons5_p25 cons5_p40 cons5_p50 cons5_p60 cons5_p75 cons5_p80 cons5_p90 cons5_p95
       cons6_p5 cons6_p10 cons6_p20 cons6_p25 cons6_p40 cons6_p50 cons6_p60 cons6_p75 cons6_p80 cons6_p90 cons6_p95
       cons7_p5 cons7_p10 cons7_p20 cons7_p25 cons7_p40 cons7_p50 cons7_p60 cons7_p75 cons7_p80 cons7_p90 cons7_p95
       cons8_p5 cons8_p10 cons8_p20 cons8_p25 cons8_p40 cons8_p50 cons8_p60 cons8_p75 cons8_p80 cons8_p90 cons8_p95;
RUN; 



DATA _null_; 
   SET cons_by_tassq cons_by_fassq cons_by_hassq
       cons_by_tassq2 cons_by_fassq2 cons_by_hassq2
       cons_by_tassq3 cons_by_fassq3 cons_by_hassq3
       cons_by_tassq4 cons_by_fassq4 cons_by_hassq4
   		 cons_by_age_grp cons_by_ed_grp cons_by_home_own;
   FILE outfile6 lrecl=1500; 
   PUT period_grp tass_quint fass_quint hass_quint age_grp ed_type ownhome pred_cons6 r_cons9;
RUN; 

